/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioArrivalCycle;
import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioOccurrenceType;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public final class VWScenarioArrivalOccurrence
implements IVWScenarioArrivalCycle,
Serializable,
Cloneable {
    private VWScenarioArrivalDefinition m_arrivalDef = null;
    private int m_type;
    private String m_qty = null;
    private String m_maxCount;
    private VWScenarioTimeDuration m_interval = null;
    private Object m_endTime = null;

    public VWScenarioArrivalOccurrence(int type, String qty, String maxCount, VWScenarioTimeDuration timeInterval, Object endTime) throws VWException {
        this.setType(type);
        this.setQuantity(qty);
        this.setMaxCount(maxCount);
        this.setTimeInterval(timeInterval);
        this.setEndTime(endTime);
    }

    protected VWScenarioArrivalOccurrence() {
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) throws VWException {
        if (!VWScenarioOccurrenceType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioArrivalOccurrence.InvalidType", "The type {0} is not a valid occurence type.", new Integer(type));
        }
        this.m_type = type;
    }

    public String getQuantity() {
        return this.m_qty;
    }

    public void setQuantity(String qty) throws VWException {
        if (qty == null) {
            throw new VWException("sim.api.VWScenarioArrivalOccurrence.NullQtyParameter", "The qty parameter can not be null.");
        }
        this.m_qty = qty;
    }

    public String getMaxCount() {
        return this.m_maxCount;
    }

    public void setMaxCount(String maxCount) {
        this.m_maxCount = maxCount;
    }

    public Object getTimeInterval() {
        return this.m_interval;
    }

    public void setTimeInterval(Object interval) throws VWException {
        if (!(interval instanceof VWScenarioTimeDuration)) {
            throw new VWException("sim.api.VWScenarioArrivalOccurrence.InvalidIntervalValue", "Invalid interval value, interval must be an instance of VWScenarioTimeDuration.");
        }
        this.m_interval = (VWScenarioTimeDuration)interval;
    }

    public Object getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Object endTime) {
        this.m_endTime = endTime;
    }

    protected Object clone() {
        VWScenarioArrivalOccurrence clone = null;
        try {
            clone = (VWScenarioArrivalOccurrence)super.clone();
            clone.m_interval = (VWScenarioTimeDuration)this.m_interval.clone();
            clone.m_endTime = VWScenarioTimeType.clone(this.m_endTime);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "");
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        buffer.append(baseIndent + "<Occurrence Quantity=\"" + this.getQuantity() + "\" ");
        buffer.append("Type=\"" + VWScenarioOccurrenceType.typeToString(this.getType()) + "\">\n");
        buffer.append(LEVEL_1_INDENT + "<Cycle>\n");
        Object occInterval = this.getTimeInterval();
        if (occInterval != null) {
            VWScenarioTimeType.timeValueToXML(occInterval, buffer, LEVEL_2_INDENT);
        }
        if (this.getEndTime() != null) {
            buffer.append(LEVEL_2_INDENT + "<EndTime>\n");
            VWScenarioTimeType.timeValueToXML(this.getEndTime(), buffer, LEVEL_3_INDENT);
            buffer.append(LEVEL_2_INDENT + "</EndTime>\n");
        }
        if (this.getMaxCount() != null) {
            buffer.append(LEVEL_2_INDENT + "<MaxCount Value=\"" + this.getMaxCount() + "\"/>\n");
        }
        buffer.append(LEVEL_1_INDENT + "</Cycle>\n");
        buffer.append(baseIndent + "</Occurrence>\n");
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioValidationError theError;
        VWString theMessage;
        String[] theErrorStrings;
        VWCompiledExpr compRes;
        VWScenarioValidationError theError2;
        VWString theMessage2;
        VWScenarioValidationError theError3;
        VWString theMessage3;
        if (this.getEndTime() != null) {
            Date absArrivalStartTime = VWScenarioTimeType.getAbsoluteTime(this.m_arrivalDef.getStartTime());
            VWScenarioTimeType.validate(this.getEndTime(), absArrivalStartTime, 7, this.m_arrivalDef.getName(), this.getArrivalDefinition().getScenarioWorkflow().getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
            Date absEndTime = VWScenarioTimeType.getAbsoluteTime(this.getEndTime());
            if (absEndTime != null && absArrivalStartTime != null && absEndTime.compareTo(absArrivalStartTime) <= 0) {
                theMessage3 = new VWString("vw.api.VWScenarioArrivalDefinition.EndTimeOutOfRange", "The arrival occurrence end date must be greater than the arrival start date.", this.m_arrivalDef.getName());
                theError3 = new VWScenarioValidationError(7, 1, this.m_arrivalDef.getName(), null, theMessage3.toString(), this.m_arrivalDef.getScenarioWorkflow().getWorkflowDefinition().getName());
                EDefVector.addElement(theError3);
            }
        }
        VWScenarioTimeType.validate(this.getTimeInterval(), null, 7, this.m_arrivalDef.getName(), this.getArrivalDefinition().getScenarioWorkflow().getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        if (this.getTimeInterval() != null && ((VWScenarioTimeDuration)this.getTimeInterval()).getDuration().equals("0")) {
            theMessage2 = new VWString("vw.api.VWScenarioArrivalOccurrence.TimeIntervalIsZero", "Arrival occurrence interval is zero.");
            theError2 = new VWScenarioValidationError(7, 2, this.getArrivalDefinition().getName(), null, theMessage2.toString());
            EDefVector.addElement(theError2);
        }
        if (this.getQuantity() != null) {
            compRes = new VWCompiledExpr();
            theErrorStrings = VWExpr.compileVWExpr(this.getQuantity(), null, null, null, null, false, compRes);
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int j = 0; j < errorCount; ++j) {
                    theMessage = new VWString("vw.api.VWScenarioArrivalOccurrence.QuantitySyntaxError", "Arrival quantity syntax error: {0}", theErrorStrings[j]);
                    theError = new VWScenarioValidationError(7, 1, this.getArrivalDefinition().getName(), this.getQuantity(), theMessage.toString());
                    EDefVector.addElement(theError);
                }
            } else if (!VWScenarioDefinition.isCompatibleType(1, compRes.getResultType()) || compRes.getResultIsArray()) {
                theMessage3 = new VWString("VWScenarioArrivalOccurrence.QuanityTypeMismatch", "Incompatible type for arrival quantity, expected {1}, found {2}.", VWFieldType.getLocalizedString(1), VWFieldType.getLocalizedString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                theError3 = new VWScenarioValidationError(7, 1, this.getArrivalDefinition().getName(), this.getQuantity(), theMessage3.toString());
                EDefVector.addElement(theError3);
            } else if (this.getQuantity().equals("0")) {
                theMessage3 = new VWString("vw.api.VWScenarioArrivalOccurrence.QuantityIsZero", "Arrival quantity is zero.");
                theError3 = new VWScenarioValidationError(7, 2, this.getArrivalDefinition().getName(), null, theMessage3.toString());
                EDefVector.addElement(theError3);
            }
        } else {
            theMessage2 = new VWString("vw.api.VWScenarioArrivalOccurrence.QuantityUndefined", "Arrival quantity is undefined.");
            theError2 = new VWScenarioValidationError(7, 1, this.getArrivalDefinition().getName(), null, theMessage2.toString());
            EDefVector.addElement(theError2);
        }
        if (this.getMaxCount() != null) {
            compRes = new VWCompiledExpr();
            theErrorStrings = VWExpr.compileVWExpr(this.getMaxCount(), null, null, null, null, false, compRes);
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int j = 0; j < errorCount; ++j) {
                    theMessage = new VWString("vw.api.VWScenarioArrivalOccurrence.MaxCountSyntaxError", "Arrival max count syntax error: {0}", theErrorStrings[j]);
                    theError = new VWScenarioValidationError(7, 1, this.getArrivalDefinition().getName(), this.getMaxCount(), theMessage.toString());
                    EDefVector.addElement(theError);
                }
            } else if (!VWScenarioDefinition.isCompatibleType(1, compRes.getResultType()) || compRes.getResultIsArray()) {
                VWString theMessage4 = new VWString("VWScenarioArrivalOccurrence.MaxCountTypeMismatch", "Incompatible type for arrival max count, expected {1}, found {2}.", VWFieldType.getLocalizedString(1), VWFieldType.getLocalizedString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                VWScenarioValidationError theError4 = new VWScenarioValidationError(7, 1, this.getArrivalDefinition().getName(), this.getMaxCount(), theMessage4.toString());
                EDefVector.addElement(theError4);
            }
        }
    }

    protected VWScenarioArrivalDefinition getArrivalDefinition() {
        return this.m_arrivalDef;
    }

    protected void setArrivalDefinition(VWScenarioArrivalDefinition arrivalDef) {
        this.m_arrivalDef = arrivalDef;
    }
}

